<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Buyers extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('buyers/mod_buyers');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(152,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Buyers', base_url().'buyers/manage-buyers');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
//		$data['ALLOW_pages_add'] =   (in_array(145,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(150,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(151,$this->session->userdata('permissions_arr'))) ? 1 : 0;

		//Fetching Pages Results
		$get_buyers = $this->mod_buyers->get_all_buyers();

		$data['buyers_arr'] = $get_buyers['buyers_arr'];
		$data['buyers_count'] = $get_buyers['buyers_count'];
		
		$this->load->view('buyers/manage_buyers',$data);
		
	}//end index()
        
        
	public function process_buyers_grid(){
            
		echo $this->mod_buyers->get_filter_buyers_grid_data();
		
	}//end 
	
        
	//Edit Buyer
	public function edit_buyer($buyer_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Buyers', base_url().'buyers/manage-buyers');
		$this->breadcrumbcomponent->add('Edit Buyer', base_url().'buyers/manage-buyers/add-new-buyer/edit-buyer/'.$buyer_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		//Fetching Table Listing
		$get_buyers_data = $this->mod_buyers->get_buyers_row($buyer_id);
                $data['buyers_row_arr'] = $get_buyers_data['buyers_row_arr'];
                $data['buyers_row_count'] = $get_buyers_data['buyers_row_count'];
                
//            exit($get_buyers_data['buyers_row_count']);
                if($get_buyers_data['buyers_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('buyers/edit_buyer',$data);
		
	}//edit_buyer

        // Edit Buyer process
	public function edit_buyer_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('upd_buyer_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$buyer_id = $this->input->post('buyer_id');

		$err_msg = '';
                if(trim($this->input->post('first_name')) == ''){
			$err_msg.= '- First Name field cannot be empty.<br>';
		}
                if(trim($this->input->post('last_name')) == ''){
			$err_msg.= '- Last Name field cannot be empty.<br>';
		}
                if(trim($this->input->post('email_address')) == ''){
			$err_msg.= '- Email field cannot be empty.<br>';
		}
              
//                if(trim($this->input->post('user_type')) == ''){
//			$err_msg.= '- User Type field cannot be empty.<br>';
//		}
                if(trim($this->input->post('status')) == ''){
			$err_msg.= '- Status field cannot be empty.<br>';
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'buyers/manage-buyers/edit-buyer/'.$buyer_id);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_buyer = $this->mod_buyers->edit_buyer($this->input->post());
		
                if($upd_buyer){

                        $this->session->set_flashdata('ok_message', '- Buyer Record has been updated successfully.');
                        redirect(base_url().'buyers/manage-buyers/');

                }else{
                        $this->session->set_flashdata('err_message', '- Buyer Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'buyers/manage-buyers/edit-buyer/'.$buyer_id);

                }//end if($upd_buyer)

	}//end edit_buyer_process
        
        
	//Delete Buyer
	public function delete_buyer($buyer_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(147,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_buyer = $this->mod_buyers->delete_buyer($buyer_id);
		
		if($del_buyer){
			
			$this->session->set_flashdata('ok_message', '- Buyer deleted successfully.');
			redirect(base_url().'buyers/manage-buyers');
			
		}else{
			$this->session->set_flashdata('err_message', '- Buyer cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'buyers/manage-buyers');
			
		}//end if

	}//end delete_table
}