<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Faqs extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('faqs/mod_faqs', 'faqs');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(162,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Faqs', base_url().'faqs/manage-faqs');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_faqs_add'] =   (in_array(163,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_faqs_edit'] =   (in_array(164,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_faqs_delete'] =   (in_array(165,$this->session->userdata('permissions_arr'))) ? 1 : 0;

		//Fetching Faqs Results
		$get_faqs = $this->faqs->get_faqs_record();

		$data['faqs_arr'] = $get_faqs['faqs_arr'];
		$data['faqs_count'] = $get_faqs['faqs_count'];
		
		$this->load->view('faqs/manage_faqs',$data);
		
	}//end index()
        
        
	public function process_faqs_grid(){
            
		echo $this->faqs->get_filter_faqs_grid_data();
		
	}//end 
	
	//Add New Faq
	public function add_new_faq(){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		//Verify if Page is Accessable
		if(!in_array(145,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Faqs', base_url().'faqs/manage-faqs');
		$this->breadcrumbcomponent->add('Add New Faq', base_url().'faqs/manage-faqs/add-new-faq');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);

		//Fetching Faq Listing
//		$get_table_list = $this->mod_table->get_all_tables();
//		$data['table_list_arr'] = $get_table_list['table_list_arr'];
//		$data['table_list_count'] = $get_table_list['table_list_count'];
		
		$this->load->view('faqs/add_new_faq',$data);
		
	}//add_new_faq
        
	public function add_new_faq_process(){
//            echo SURL."faqs/manage-faqs/add-new-faq.'<br />'";
            
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_new_faq_sbt')) redirect(base_url().'faqs/manage-faqs/add-new-faq');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(145,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
            
		$data_arr['add-new-faq-data'] = $this->input->post();
		$this->session->set_userdata($data_arr);

		if(trim($this->input->post('question')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Qustion field is empty.');
			redirect(base_url().'faqs/manage-faqs/add-new-faq');
			
		}//end if(trim($this->input->post('faq_name')) == '')
		elseif(trim($this->input->post('answer')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Answer field is empty.');
			redirect(base_url().'faqs/manage-faqs/add-new-faq');
			
		}//end elseif(trim($this->input->post('answer')) == '')
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Please Select the Status by dropdown.');
			redirect(base_url().'faqs/manage-faqs/add-new-faq');
			
		}//end elseif(trim($this->input->post('status')) == '')

                else{
//                    echo 'else....'; exit();
			$add_new_faq = $this->faqs->add_new_faq($this->input->post());

			if($add_new_faq){
				
				//Unset POST values from session
				$this->session->unset_userdata('add-new-faq-data');
				
				$this->session->set_flashdata('ok_message', '- New Faq has been added successfully.');
				redirect(base_url().'faqs/manage-faqs');
				
			}else{
				$this->session->set_flashdata('err_message', '- New Faq is not added. Something went wrong, please try again.');
				redirect(base_url().'faqs/manage-faqs/add-new-faq');
				
			}//end if($add_new_faq)
			
		}//end 

	}//end add_new_faq_process   
        
        
	//Edit Faq
	public function edit_faq($faq_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Faqs', base_url().'faqs/manage-faqs');
		$this->breadcrumbcomponent->add('Edit Faq', base_url().'faqs/manage-faqs/add-new-faq/edit-faq/'.$faq_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		//Fetching Faq Listing
		$get_faqs_data = $this->faqs->get_faqs_row($faq_id);
                $data['faqs_row_arr'] = $get_faqs_data['faqs_row_arr'];
                $data['faqs_row_count'] = $get_faqs_data['faqs_row_count'];
                
//            exit($get_faqs_data['faqs_row_count']);
                if($get_faqs_data['faqs_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('faqs/edit_faq',$data);
		
	}//edit_faq

        // Edit Faq process
	public function edit_faq_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('upd_faq_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$faq_id = $this->input->post('faq_id');

		$err_msg = '';
		if(trim($this->input->post('question')) == ''){
			
			$err_msg.= '- Question field cannot be empty.<br>';
			
		}//end if(trim($this->input->post('question')) == '')
		elseif(trim($this->input->post('answer')) == ''){
			
			$err_msg.= '- Answer field cannot be empty.<br>';
			
		}
		elseif(trim($this->input->post('status')) == ''){
			
			$err_msg.= '- Please Select the status.<br>';
			
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'faqs/manage-faqs/edit-faq/'.$faq_id);
			
		}//end if($err_msg !='')

		//Updating Faq Data
		$upd_faq = $this->faqs->edit_faq($this->input->post());
		
                if($upd_faq){

                        $this->session->set_flashdata('ok_message', '- Faq Record has been updated successfully.');
//                        redirect(base_url().'faqs/manage-faqs/edit-faq/'.$faq_id);
                        redirect(base_url().'faqs/manage-faqs/');

                }else{
                        $this->session->set_flashdata('err_message', '- Faq Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'faqs/manage-faqs/edit-faq/'.$faq_id);

                }//end if($upd_faq)

	}//end edit_faq_process
        
        
	//Delete Faq
	public function delete_faq($faq_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(147,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_faq = $this->faqs->delete_faq($faq_id);
		
		if($del_faq){
			
			$this->session->set_flashdata('ok_message', '- Faq deleted successfully.');
			redirect(base_url().'faqs/manage-faqs');
			
		}else{
			$this->session->set_flashdata('err_message', '- Faq cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'faqs/manage-faqs');
			
		}//end if

	}//end delete_table
}