<?php
class mod_services extends CI_Model {
	
	function __construct(){
		
        parent::__construct();
    }
	//Get All Services.
	public function get_all_services(){
		
		$this->db->dbprefix('services');
		$this->db->order_by('id DESC');
		$get_services = $this->db->get('services');

		//echo $this->db->last_query();
		$row_services['services_arr'] = $get_services->result_array();
		$row_services['services_count'] = $get_services->num_rows;
		return $row_services;
		
	}//end get_all_services


    //Filter Grid for Manage Services
    public function get_filter_services_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('service_name', 'status', 'id');

        // DB table to use
        $sTable = 'services';
        $this->db->order_by('id DESC');


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
        foreach ($rResult->result_array() as $aRow) {
            $row = array();
            $option_html = '';
            foreach ($aColumns as $col) {

                if ($col == 'service_name') {
                    $row[] = "<strong>" . $aRow['service_name'] . "</strong>";
                }
//                elseif($col == 'service_type'){
//                        $row[] = "<strong>" . $aRow['service_type'] . "</strong>";
//                }
//                elseif($col == 'last_signin_date'){
//                        $row[] = date('d, M Y h:i:s a', strtotime(stripslashes($aRow['last_signin_date'])));
//                }
//                elseif ($col == 'created_date') {
////                    $row[] = date('d, M Y, h:i:s a', (strtotime($aRow['created_date'])));
//                    $row[] = date('d, M Y', (strtotime($aRow['created_date'])));
//                } 
                elseif ($col == 'status') {
                    $row[] = ($aRow[$col] == 1) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';
                } 
                elseif ($col == 'id') {
                    $option_html .= '<div class="btn-group">';

                    if (in_array(146, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "services/manage-services/edit-service/" . $aRow['id'] . " type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
                    }//end if

                    if (in_array(147, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "services/manage-services/delete-service/" . $aRow['id'] . " type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
                    }//end if


                    $option_html .= '</div>';
                    $row[] = $option_html;
                } else
                    $row[] = $aRow[$col];
            }

            $output['aaData'][] = $row;
        }


        echo json_encode($output);
    } //end get_filter_services_grid_data        

public function get_service_image($service_id){
	
	
		$this->db->dbprefix('services');
		$this->db->where('id',$service_id);
		$get_service = $this->db->get('services');

		//echo $this->db->last_query(); exit;
		$row_service_image['service_image_arr'] = $get_service->row_array();
		$row_service_image['service_image_count'] = $get_service->num_rows;
		return $row_service_image;
		
	}




    
    //Add New Service
    public function add_new_service($data) {
			extract($data);
			$generate_seo_url = $this->mod_common->generate_seo_url($service_name);
			$verified_seo_url = $this->mod_common->verify_seo_url($generate_seo_url,'services','seo_url_name',0);
		if($_FILES['service_image']['name'] != ''){

			//Create User Directory if not exist
			$slider_folder_path = '../assets/serviceimages';
	
			$file_ext           = ltrim(strtolower(strrchr($_FILES['service_image']['name'],'.')),'.'); 			
			$file_name = 	'service-'.date('YmdGis').'.jpg';

			$config['upload_path'] = $slider_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '6000';
			$config['overwrite'] = true;
			$config['file_name'] = $file_name;
		
			$this->load->library('upload', $config);

			if(!$this->upload->do_upload('service_image')){
				
				$error_file_arr = array('error' => $this->upload->display_errors());
				return $error_file_arr;
				
			}else{

				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 800 * 600
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 800;
				$config_profile['height'] = 600;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();

				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 230;
				$config_profile['height'] = 150;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/home/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 370;
				$config_profile['height'] = 570;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
			}//end if(!$this->upload->do_upload('prof_image'))


		}//end if($_FILES['slider_image']['name'] != '')

//        $table_seats = $this->input->post('table_seats');
        $created_date = date('Y-m-d G:i:s');
        $ip_address = $this->input->ip_address();
        $created_by = $this->session->userdata('admin_id_sec_erp');

        $ins_data = array(
						'service_name' => $this->db->escape_str(trim($service_name)),
						'service_description' => $this->db->escape_str(trim($service_description)),
						'service_long_desc' => trim($service_long_desc),
						'sortorder' => $this->db->escape_str(trim($ordertype)),
						'isfeatured' => $this->db->escape_str(trim($isfeature)),
						'service_image' => $this->db->escape_str(trim($file_name)),
						'status' => $this->db->escape_str(trim($status)),
						'seo_title' => $this->db->escape_str(trim($seo_title)),
						'meta_keywords' => $this->db->escape_str(trim(nl2br($meta_keywords))),
						'meta_description' => $this->db->escape_str(trim(nl2br($meta_description))) , 
						'seo_url_name' => $this->db->escape_str(trim($verified_seo_url)),
						'created_by' => $this->db->escape_str(trim($created_by)),
						'created_by_ip' => $this->db->escape_str(trim($ip_address)),
						'created_date' => $this->db->escape_str(trim($created_date)),
//		   'table_discription' =>     $this->db->escape_str(trim(nl2br($table_discription))),
        );

        //Insert the record into the database.
        $this->db->dbprefix('services');
        $ins_into_db = $this->db->insert('services', $ins_data);

        if ($ins_into_db)
            return true;
    } //end add_new_service()

    
    //Delete Services Record
    public function delete_service($service_id) {

        //Delete the record from the database.
        $this->db->dbprefix('services');
        $this->db->where('id', $service_id);
        $del_into_db = $this->db->delete('services');
        if ($del_into_db)
            return true;
        //	echo $this->db->last_query();
    } //end delete_service

    

    
    // get specific record    
    function get_services_row($service_id) {

        $this->db->dbprefix('services');
        $this->db->where('id', $service_id);
        $get_services_row = $this->db->get('services');
        //        echo $this->db->last_query();

        $services_row['services_row_arr'] = $get_services_row->row_array();
        $services_row['services_row_count'] = $get_services_row->num_rows;

        return $services_row;
    }
// end get_table_seats_row

    //Edit Service Data
    public function edit_service($data) {
	 extract($data);
	 $generate_seo_url = $this->mod_common->generate_seo_url($service_name);
	 $verified_seo_url = $this->mod_common->verify_seo_url($generate_seo_url,'services','seo_url_name',0);
	 
	$get_service_data = $this->get_service_image($service_id);
		$get_service_data_arr = $get_service_data['service_image_arr'];
	 $old_file_name = $get_service_data_arr['service_image'];
 
		if($_FILES['service_image']['name'] != ''){


			//Create User Directory if not exist
			$slider_folder_path = '../assets/serviceimages';
	
			$file_ext           = ltrim(strtolower(strrchr($_FILES['service_image']['name'],'.')),'.'); 			
			  $file_name = 	'service-'.date('YmdGis').'.jpg';

			$config['upload_path'] = $slider_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '6000';
			$config['overwrite'] = true;
			$config['file_name'] = $file_name;
		
			$this->load->library('upload', $config);

			if(!$this->upload->do_upload('service_image')){
				
				$error_file_arr = array('error' => $this->upload->display_errors());
				return $error_file_arr;
				
			}else{
				
				
				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 800 * 600
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 800;
				$config_profile['height'] = 600;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();

				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 230;
				$config_profile['height'] = 150;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $slider_folder_path.'/'.$file_name;
				$config_profile['new_image'] = $slider_folder_path.'/thumb/home/'.$file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 370;
				$config_profile['height'] = 570;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
			}//end if(!$this->upload->do_upload('prof_image'))

			//Delete Existing Image
			if(file_exists($slider_folder_path.'/'.$old_file_name)){
				
				unlink($slider_folder_path.'/'.$old_file_name);
				unlink($slider_folder_path.'/thumb/'.$old_file_name);
			}

		}else{
			$file_name = $old_file_name;	
		}
       

        $last_modified_date = date('Y-m-d G:i:s');
        $last_modified_ip = $this->input->ip_address();
        $last_modified_by = $this->session->userdata('service_id');


        $upd_data = array(
						'service_name' => $this->db->escape_str(trim($service_name)),
						'service_description' => $this->db->escape_str(trim($service_description)),
						'service_long_desc' => trim($service_long_desc),
						'sortorder' => $this->db->escape_str(trim($ordertype)),
						'isfeatured' => $this->db->escape_str(trim($isfeature)),
						'service_image' => $this->db->escape_str(trim($file_name)),
						'status' => $this->db->escape_str(trim($status)),
						'seo_title' => $this->db->escape_str(trim($seo_title)),
						'meta_keywords' => $this->db->escape_str(trim(nl2br($meta_keywords))),
						'meta_description' => $this->db->escape_str(trim(nl2br($meta_description))) , 
						'seo_url_name' => $this->db->escape_str(trim($verified_seo_url)),
						'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
						'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
						'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip))
        );


        //Updating the record into the database.
        $this->db->dbprefix('services');
        $this->db->where('id', $service_id);
        $upd_into_db = $this->db->update('services', $upd_data);
        //echo $this->db->last_query(); exit;

        if ($upd_into_db)
            return true;
    }

//end edit_table
}
