<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Services extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('services/mod_services');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(144,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Services', base_url().'services/manage-services');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_pages_add'] =   (in_array(145,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(146,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(147,$this->session->userdata('permissions_arr'))) ? 1 : 0;

		//Fetching Pages Results
		$get_services = $this->mod_services->get_all_services();

		$data['services_arr'] = $get_services['services_arr'];
		$data['services_count'] = $get_services['services_count'];
		
		$this->load->view('services/manage_services',$data);
		
	}//end index()
        
        
	public function process_services_grid(){
            
		echo $this->mod_services->get_filter_services_grid_data();
		
	}//end 
	
	//Add New Service
	public function add_new_service(){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		//Verify if Page is Accessable
		if(!in_array(145,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Services', base_url().'services/manage-services');
		$this->breadcrumbcomponent->add('Add New Service', base_url().'services/manage-services/add-new-service');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);

		//Fetching Table Listing
//		$get_table_list = $this->mod_table->get_all_tables();
//		$data['table_list_arr'] = $get_table_list['table_list_arr'];
//		$data['table_list_count'] = $get_table_list['table_list_count'];
		
		$this->load->view('services/add_new_service',$data);
		
	}//add_new_service
        
	public function add_new_service_process(){
//            echo SURL."services/manage-services/add-new-service.'<br />'";
            
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_new_service_sbt')) redirect(base_url().'services/manage-services/add-new-service');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(145,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
            
		$data_arr['add-new-service-data'] = $this->input->post();
		$this->session->set_userdata($data_arr);

		if(trim($this->input->post('service_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Service Name field is empty.');
			redirect(base_url().'services/manage-services/add-new-service');
			
		}//end if(trim($this->input->post('service_name')) == '')
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Service Type field is empty.');
			redirect(base_url().'services/manage-services/add-new-service');
			
		}//end elseif(trim($this->input->post('status')) == '')

                else{
//                    echo 'else....'; exit();
			$add_new_service = $this->mod_services->add_new_service($this->input->post());

			if($add_new_service){
				
				//Unset POST values from session
				$this->session->unset_userdata('add-new-service-data');
				
				$this->session->set_flashdata('ok_message', '- New Service has been added successfully.');
				redirect(base_url().'services/manage-services');
				
			}else{
				$this->session->set_flashdata('err_message', '- New Service is not added. Something went wrong, please try again.');
				redirect(base_url().'services/manage-services/add-new-service');
				
			}//end if($add_new_service)
			
		}//end 

	}//end add_new_service_process   
        
        
	//Edit Table
	public function edit_service($service_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Services', base_url().'services/manage-services');
		$this->breadcrumbcomponent->add('Edit Service', base_url().'services/manage-services/add-new-service/edit-service/'.$service_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		//Fetching Table Listing
		$get_services_data = $this->mod_services->get_services_row($service_id);
                $data['services_row_arr'] = $get_services_data['services_row_arr'];
                $data['services_row_count'] = $get_services_data['services_row_count'];
                
//            exit($get_services_data['services_row_count']);
                if($get_services_data['services_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('services/edit_service',$data);
		
	}//edit_service

        // Edit Service process
	public function edit_service_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('upd_service_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(146,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$service_id = $this->input->post('service_id');

		$err_msg = '';
		if(trim($this->input->post('service_name')) == ''){
			
			$err_msg.= '- Service Name field cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		elseif(trim($this->input->post('status')) == ''){
			
			$err_msg.= '- Service Type field cannot be empty.<br>';
			
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'services/manage-services/edit-service/'.$service_id);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_service = $this->mod_services->edit_service($this->input->post());
		
                if($upd_service){

                        $this->session->set_flashdata('ok_message', '- Service Record has been updated successfully.');
//                        redirect(base_url().'services/manage-services/edit-service/'.$service_id);
                        redirect(base_url().'services/manage-services/');

                }else{
                        $this->session->set_flashdata('err_message', '- Service Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'services/manage-services/edit-service/'.$service_id);

                }//end if($upd_service)

	}//end edit_service_process
        
        
	//Delete Service
	public function delete_service($service_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(147,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_service = $this->mod_services->delete_service($service_id);
		
		if($del_service){
			
			$this->session->set_flashdata('ok_message', '- Service deleted successfully.');
			redirect(base_url().'services/manage-services');
			
		}else{
			$this->session->set_flashdata('err_message', '- Service cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'services/manage-services');
			
		}//end if

	}//end delete_table
}