<!--view/table/edit_table-->
<!DOCTYPE html>
<html>
<head>

<!-- Meta, title, CSS, favicons, etc. -->
<meta charset="utf-8">
<title><?php echo $meta_title ?></title>
<meta name="keywords" content="<?php echo $meta_keywords ?>" />
<meta name="description" content="<?php echo $meta_description ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php echo $INC_header_script_top; ?>
</head>

<body>
<!-- Start: Header -->
<header class="navbar navbar-fixed-top"> <?php echo $INC_top_header; ?> </header>
<!-- End: Header --> 
<!-- Start: Main -->
<div id="main"> 
  <!-- Start: Sidebar --> 
  <?php echo $INC_left_nav_panel; ?> 
  <!-- End: Sidebar --> 
  <!-- Start: Content -->
  <section id="content"> <?php echo $INC_breadcrum?>
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="panel">
            <div class="panel-heading">
              <div class="panel-title"> <span class="glyphicon glyphicon-book"></span> Edit Faq </div>
              <ul class="nav panel-tabs">
                <li class="active"><a href="#data_content" data-toggle="tab">Data Contents</a></li>
              </ul>
            </div>
            <div class="panel-body alerts-panel">
              <form class="cmxform" id="upd_faq_frm" method="POST" action="<?php echo SURL?>faqs/manage-faqs/edit-faq-process">
                <div class="tab-content border-none padding-none">
                
                  <div id="data_content" class="tab-pane active">
					<?php
                        if($this->session->flashdata('err_message')){
                    ?>
                            <div class="alert alert-danger"><?php echo $this->session->flashdata('err_message'); ?></div>
                    <?php
                        }//end if($this->session->flashdata('err_message'))
                        
                        if($this->session->flashdata('ok_message')){
                    ?>
                            <div class="alert alert-success alert-dismissable"><?php echo $this->session->flashdata('ok_message'); ?></div>
                    <?php 
                        }//if($this->session->flashdata('ok_message'))
						
                    ?>
                            
                      <div class="row form-group">
                          <div class="col-md-5">
                            <label for="question">Question*</label>
                            <!--<input id="question" name="question" type="text" class="form-control" placeholder="Put Your Question" value="< ?php echo $faqs_row_arr['question']; ?>" required/>-->
                            <textarea class="form-control" rows="3" id="question" name="question" placeholder="Put Your Question"  required><?php echo $faqs_row_arr['question']; ?></textarea>
                          </div>
                      </div>
                            
                      <div class="row form-group">
                          <div class="col-md-5">
                            <label for="Answer">Answer*</label>
                            <!--<input id="answer" name="answer" type="text" class="form-control" placeholder="Put Your Answer" value="< ?php echo $faqs_row_arr['answer']; ?>" required/>-->
                            <textarea class="form-control" rows="10" id="answer" name="answer" placeholder="Put Your Answer" required ><?php echo $faqs_row_arr['answer']; ?></textarea>
                          </div>
                      </div>
                            

                            
                    <div class="row form-group">
                        <div class="col-md-5">
                          <label for="status">Status</label>
                          <span id="state_response">
                                <select  id="status-tab"     name="status" style="width:100%;">
                                <option value="">Select Status</option>
                                <option value="1" <?php echo ($faqs_row_arr['status'] == 1) ? 'selected' : ''?> >Active</option>
                                <option value="0" <?php echo ($faqs_row_arr['status'] == 0) ? 'selected' : ''?> >InActive</option>
                        	</select>
                          </span>  
                        </div>
                    </div>                           

                  </div>

                    <div class="form-group" align="right" style="margin-right:17px">
                    	<input class="submit btn btn-blue" type="submit" name="upd_faq_sbt" id="upd_new_cat_sbt" value="Update Faq" />
                        <input type="hidden" name="faq_id" id="faq_id" value="<?php echo stripslashes($faqs_row_arr['id'])?>" readonly>
                    </div>
                </div>
				
              </form>
            </div>
          </div>
        </div>
      </div>
      <div class="clearfix"></div>
      <div class="row" style="min-height:325px;">&nbsp;</div>
    </div>
  </section>
  <!-- End: Content --> 
  
</div>
<!-- End: Main --> 
<!-- Start: Footer -->
<footer > <?php echo $INC_footer;?> </footer>
<!-- End: Footer --> 
<?php echo $INC_header_script_footer;?>
<link href="<?php echo CSS ;?>select2.css" rel="stylesheet"/>
<script src="<?php echo JS ; ?>select2.js"></script>
 <script>
$(document).ready(function() { $("#status-tab").select2();  $("#faq-types").select2();  });
</script>
    <script type="text/javascript">
      jQuery(document).ready(function() {
    
      // validate signup form on keyup and submit
        $("#upd_faq_frm").validate({
            rules: {
                question: "required",
                answer: "required",
                status: "required",
//                parent_id: "required",
//				display_order: {
//					required: false,
//					digits: true
//
//				},
                
            },
			
            messages: {
                question: "Please put your question.",
                answer: "Please put your answer.",
                status: "Please select the status.",
//                parent_id: "Select Parent Category.",
//                display_order : "Use digit to set a display order"
            }
        });
    
    });
    </script>

</body>
</html>
