<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Gallery extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('gallery/mod_gallery');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(174,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Gallery', base_url().'gallery/manage-gallery');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_gallery_edit'] =   (in_array(176,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_gallery_delete'] = (in_array(177,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_gallery_add'] =    (in_array(175,$this->session->userdata('permissions_arr'))) ? 1 : 0;

		//Fetching Pages Results
		$get_images = $this->mod_gallery->get_all_gallery_images();

		$data['images_arr'] = $get_images['images_arr'];
		$data['images_count'] = $get_images['images_count'];
		
		$this->load->view('gallery/manage_gallery',$data);
		
	}//end index()
	
	//Add New Slider Image
	public function add_gallery(){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(175,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage  Gallery', base_url().'gallery/manage-gallery');
		$this->breadcrumbcomponent->add('Add New Gallery', base_url().'gallery/manage-gallery/add-gallery');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();

		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] =  $this->load->view('common/breadcrum','',true);
		$where=array('status'=>1);
		$data['catgory'] =  $this->mod_common->get_data_by_where('bir_categories',$fields = false,$where);
		$this->load->view('gallery/add_new_gallery',$data);
		
	}//add_new_page

	public function add_new_image_process(){
		
		
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_image_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(175,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		if($err_msg !=''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'gallery/manage-gallery/add-gallery');
			
		}//end if($err_msg !='')
		

		$data_arr['add-image-data'] = $this->input->post();
		$this->session->set_userdata($data_arr);

		if(trim($_FILES['slider_image']['name']) == ''){
			
			$this->session->set_flashdata('err_message', '- Select Slider Image.');
			redirect(base_url().'gallery/manage-gallery/add-gallery');
			
		}//end if 
		
		
	
		

		//Adding New Slider Image
		$add_image = $this->mod_gallery->add_new_image($this->input->post());

		if($add_image && $add_image['error'] == ''){		
			
			//Unset POST values from session
			$this->session->unset_userdata('add-image-data');
			
			$this->session->set_flashdata('ok_message', '- New  Image added successfully.');
			redirect(base_url().'gallery/manage-gallery');
			
		}else{
			
			if($add_image['error'] != ''){

				$this->session->set_flashdata('err_message', '- '.strip_tags($add_slider_image['error']));
				redirect(base_url().'gallery/manage-gallery/add-gallery');
				
			}else{
				$this->session->set_flashdata('err_message', '- New  Image is not uploaded. Something went wrong, please try again.');
				redirect(base_url().'gallery/manage-gallery/add-gallery');
				
			}//end if($add_new_article['error'] != '')
			
		}//end if($add_slider_image)

	}//end add_page_process

	//Edit Page
	public function edit_image($image_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();
        $page_id = $image_id;
		//Verify if Page is Accessable
		if(!in_array(176,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 1;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Gallery', base_url().'gallery/manage-gallery');
		$this->breadcrumbcomponent->add('Edit Gallery', base_url().'gallery/manage-gallery/edit-image/'.$page_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		$where=array('status'=>1);
		$data['catgory'] =  $this->mod_common->get_data_by_where('bir_categories',$fields = false,$where);
		//Fetching Image slider Results
		$get_image = $this->mod_gallery->get_gallery_image($image_id);
		$data['image_data'] = $get_image['image_arr'];
		$data['image_count'] = $get_image['image_count'];
		
		if($get_image['image_count'] == 0) redirect(base_url());
		
		$this->load->view('gallery/edit_gallery',$data);
		
	}//add_new_page

	public function edit_image_process(){
		
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('upd_image_sbt')) redirect(base_url());
		
		$image_id = $this->input->post('image_id');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(176,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Updating Image slider
		$upd_image = $this->mod_gallery->edit_image($this->input->post());
		
		if($upd_image && $upd_image['error'] == ''){	
			
			$this->session->set_flashdata('ok_message', '-  Image updated successfully.');
			redirect(base_url().'gallery/manage-gallery/');
			
		}else{

			if($upd_slider_image['error'] != ''){

				$this->session->set_flashdata('err_message', '- '.strip_tags($upd_slider_image['error']));
				redirect(base_url().'gallery/manage-gallery/edit-image/'.$image_id);
				
			}else{
				
				$this->session->set_flashdata('err_message', '- Image is not updated. Something went wrong, please try again.');
				redirect(base_url().'gallery/manage-gallery/edit-image/'.$image_id);

			}//end if($add_slider_image['error'] != '')
			
		}//end if($add_cms_page)

	}//end add_page_process
	
	public function delete_image($image_id){
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(177,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//If Post is not SET
		if(!isset($image_id)) redirect(base_url());
		
		//Updating Page
		$del_slider_image = $this->mod_gallery->delete_image($image_id);
		
		if($del_slider_image){
			
			$this->session->set_flashdata('ok_message', '- Image deleted successfully.');
			redirect(base_url().'gallery/manage-gallery/');
			
		}else{
			$this->session->set_flashdata('err_message', '- Image cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'gallery/manage-gallery/');
			
		}//end if($add_cms_page)

	}//end delete_page

}//end Dashboard 
