<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_Sellers extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('sellers/mod_sellers');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
            
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(148,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Sellers', base_url().'sellers/manage-sellers');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
//		$data['ALLOW_pages_add'] =   (in_array(145,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(150,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(151,$this->session->userdata('permissions_arr'))) ? 1 : 0;

		//Fetching Pages Results
		$get_sellers = $this->mod_sellers->get_all_sellers();

		$data['sellers_arr'] = $get_sellers['sellers_arr'];
		$data['sellers_count'] = $get_sellers['sellers_count'];
		
		$this->load->view('sellers/manage_sellers',$data);
		
	}//end index()
        
        
	public function process_sellers_grid(){
            
		echo $this->mod_sellers->get_filter_sellers_grid_data();
		
	}//end 
	
        
	//Edit Seller
	public function edit_seller($seller_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(150,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Sellers', base_url().'sellers/manage-sellers');
		$this->breadcrumbcomponent->add('Edit Seller', base_url().'sellers/manage-sellers/add-new-seller/edit-seller/'.$seller_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		//Fetching Table Listing
		$get_sellers_data = $this->mod_sellers->get_sellers_row($seller_id);
                $data['sellers_row_arr'] = $get_sellers_data['sellers_row_arr'];
                $data['sellers_row_count'] = $get_sellers_data['sellers_row_count'];
                
//            exit($get_sellers_data['sellers_row_count']);
                if($get_sellers_data['sellers_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('sellers/edit_seller',$data);
		
	}//edit_seller

        // Edit seller process
	public function edit_seller_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('upd_seller_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(150,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$seller_id = $this->input->post('seller_id');

		$err_msg = '';
                if(trim($this->input->post('first_name')) == ''){
			$err_msg.= '- First Name field cannot be empty.<br>';
		}
                if(trim($this->input->post('last_name')) == ''){
			$err_msg.= '- Last Name field cannot be empty.<br>';
		}
                if(trim($this->input->post('email_address')) == ''){
			$err_msg.= '- Email field cannot be empty.<br>';
		}
              
//                if(trim($this->input->post('user_type')) == ''){
//			$err_msg.= '- User Type field cannot be empty.<br>';
//		}
                if(trim($this->input->post('status')) == ''){
			$err_msg.= '- Status field cannot be empty.<br>';
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'sellers/manage-sellers/edit-seller/'.$seller_id);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_seller = $this->mod_sellers->edit_seller($this->input->post());
		
                if($upd_seller){

                        $this->session->set_flashdata('ok_message', '- Seller Record has been updated successfully.');
//                        redirect(base_url().'sellers/manage-sellers/edit-service/'.$service_id);
                        redirect(base_url().'sellers/manage-sellers/');

                }else{
                        $this->session->set_flashdata('err_message', '- Seller Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'sellers/manage-sellers/edit-seller/'.$seller_id);

                }//end if($upd_seller)

	}//end edit_seller_process
        
        
	//Delete Seller
	public function delete_seller($seller_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(147,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_seller = $this->mod_sellers->delete_seller($seller_id);
		
		if($del_seller){
			
			$this->session->set_flashdata('ok_message', '- Seller deleted successfully.');
			redirect(base_url().'sellers/manage-sellers');
			
		}else{
			$this->session->set_flashdata('err_message', '- Seller cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'sellers/manage-sellers');
			
		}//end if

	}//end delete_table
}