<?php
class mod_admin extends CI_Model {
	
	function __construct(){
		
        parent::__construct();
    }

	//Verify If User is Login on the authorized Pages.
	public function verify_is_admin_login(){
		if(!$this->session->userdata('admin_id_sec_erp')){
			
			$this->session->set_flashdata('err_message', '- You have to login to access this page.');
			redirect(base_url().'login/login');
			
		}//if(!$this->session->userdata('id'))
		
	}//end verify_is_user_login()

	## UPDATE PROFILE ##
	
	
	//Get Admin Profile Record
	public function get_admin_profile($admin_id){
		
		$this->db->select('id, first_name, last_name, display_name, username, email_address, profile_image,country_name,state_name,city_name');
		$this->db->dbprefix('admin');
		$this->db->where('id',$admin_id);
		$get_admin_profile = $this->db->get('admin');

		//echo $this->db->last_query();
		$row_admin['admin_profile_arr'] = $get_admin_profile->row_array();
		$row_admin['admin_profile_count'] = $get_admin_profile->num_rows;
		return $row_admin;
		
	}//end get_admin_profile
	
	
	
	
	//Updatiing Admin Profile
	public function update_admin_profile($data,$admin_id){
		
		extract($data);
		
		$last_modified_date = date('Y-m-d G:i:s');
		$last_modified_ip = $this->input->ip_address();
		$last_modified_by = $this->session->userdata('admin_id');

		$upd_data = array(
		   'first_name' => $this->db->escape_str(trim($first_name)),
		   'last_name' => $this->db->escape_str(trim($last_name)),
		   'display_name' => $this->db->escape_str(trim($display_name)),
		   'username' => $this->db->escape_str(trim($username)),
		   'email_address' => $this->db->escape_str(trim($email_address)),
		   'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
		   'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
		   'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip))
		);		

		//Create User Directory if not exist
		$user_folder_path = './assets/user_files/'.$admin_id;
		
		if(!is_dir($user_folder_path))
			mkdir($user_folder_path);
			
		//Uploading profile Imaage
		if($_FILES['prof_image']['name'] != ''){
			
			$file_ext           = ltrim(strtolower(strrchr($_FILES['prof_image']['name'],'.')),'.'); 			
			$profile_file_name = 	'user_profile_'.$admin_id.'.jpg';

			$config['upload_path'] = $user_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '1000';
			$config['overwrite'] = true;
			$config['file_name'] = $profile_file_name;
		
			$this->load->library('upload', $config);
			
			
			if(!$this->upload->do_upload('prof_image')){
				
				 
				$error_file_arr = array('error' => $this->upload->display_errors());
				
				return $error_file_arr;
				
			}else{
				
				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 180 * 180
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 180;
				$config_profile['height'] = 180;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
				
				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
				$config_profile['new_image'] = $user_folder_path.'/t1-'.$profile_file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 28;
				$config_profile['height'] = 28;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
	
			}//end if else if(!$this->upload->do_upload('upload_cv'))
			
			$upd_data['profile_image'] = $this->db->escape_str(trim($profile_file_name));

			$add_profile_to_session = array(
				'profile_image'	=>	trim($profile_file_name),
			);
				
			$this->session->set_userdata($add_profile_to_session);			
			
		}//end if($_FILES['prof_image']['name'] != '')

		//Update the record into the database.
		$this->db->dbprefix('admin');
		$this->db->where('id',$admin_id);
		$upd_into_db = $this->db->update('admin', $upd_data);
		
		//echo $this->db->last_query();
		
		if($upd_into_db){

			$login_sess_array = array(
				'display_name'	=>	$display_name,
				'email_address'	=>	$mail_address,
				);
					
				$this->session->set_userdata($login_sess_array);
			
			return true;
			
		}//end if($upd_into_db)
		
	}//end update_admin_profile

	## CHANGE PASSWORD ##
	
	//Updatiing Admin Password
	public function update_admin_password($data,$admin_id){
		
		extract($data);
		
		$last_modified_date = date('Y-m-d G:i:s');
		$last_modified_ip = $this->input->ip_address();
		$last_modified_by = $this->session->userdata('admin_id');

		$upd_data = array(
		   'password' => $this->db->escape_str(trim(md5($new_password))),
		   'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
		   'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
		   'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip))
		);		

		//Update the record into the database.
		$this->db->dbprefix('admin');
		$this->db->where('id',$admin_id);
		$upd_into_db = $this->db->update('admin', $upd_data);
		
		//echo $this->db->last_query();
		
		if($upd_into_db)
			return true;
			
	}//end update_admin_password
	
	## ADMIN USER MANAGEMENT ##
	
	//Get Admin User Record
	public function get_admin_user_data($admin_id){
		
		$this->db->dbprefix('admin');
		$this->db->where('id',$admin_id);
		$get_admin = $this->db->get('admin');

		//echo $this->db->last_query();
		$row_admin['admin_user_arr'] = $get_admin->row_array();
		$row_admin['admin_user_count'] = $get_admin->num_rows;
		
	    $county_code=$row_admin['admin_user_arr']['country_name'];
		
		
		$this->db->dbprefix('countries');
		$this->db->where('iso',$county_code);
		$get_country = $this->db->get('countries');
		$row_country = $get_country->row_array();
		
		$row_admin['admin_user_arr']['country']=$row_country['country_name'];
		
		return $row_admin;
		
	}//end get_admin_user_data

	
	//Get Total Number of admin Users in Database
	public function count_total_admin_users(){
		
		$this->db->dbprefix('admin');
		return $this->db->count_all("admin");
		
	}//end count_total_admin_users

	//Get All Admin Users record.
	public function get_admin_users_limit($start, $limit){
		
		$this->db->dbprefix('admin');
		$this->db->select('admin.*,admin_roles.role_title');
		$this->db->where('is_sup_admin != 1');
		$this->db->join('admin_roles','admin_roles.id = admin.admin_role_id');
		$this->db->limit($limit,$start);
		$this->db->order_by('admin.created_date DESC');
		
		$get_admin_user_list_limit = $this->db->get('admin');
		//echo $this->db->last_query();exit;
		
		$row_admin_user_list_limit['admin_list_result'] = $get_admin_user_list_limit->result_array();
		$row_admin_user_list_limit['admin_list_result_count'] = $get_admin_user_list_limit->num_rows;
		
		
		
		
		return $row_admin_user_list_limit;		
		
	}//end get_all_admin_users_limit
	
	//Check if username already exist
	public function check_if_username_exist($username){
		
		$this->db->dbprefix('admin');
		$this->db->select('id,');
		$this->db->dbprefix('admin');
		$this->db->where('username',$username);
		$get_count = $this->db->get('admin');
		
		$num_if_rows = $get_count->num_rows;
		
		//echo $this->db->last_query();

		if($num_if_rows > 0) return true;
		else 
		return false;

		//echo $this->db->last_query();
		
	}//end check_if_username_exist

	//Add new Admin User
	public function add_new_user($data){
		
		extract($data);
		
		$dob = date("Y-m-d", strtotime($dob));
		$join_date = date("Y-m-d", strtotime($join_date));
		$last_increament = date("Y-m-d", strtotime($last_increament));
		
		
		$created_date = date('Y-m-d G:i:s');
		$created_by_ip = $this->input->ip_address();
		$created_by = $this->session->userdata('admin_id');

		$ins_data = array(
		   'first_name' => $this->db->escape_str(trim($first_name)),
		   'last_name' => $this->db->escape_str(trim($last_name)),
		   'display_name' => $this->db->escape_str(trim($display_name)),
		   'username' => $this->db->escape_str(trim($username)),
		   'email_address' => $this->db->escape_str(trim($email_address)),
		   'zip' => $this->db->escape_str(trim($zip)),
		   'phone' => $this->db->escape_str(trim($phone)),
		   'country_name' => $this->db->escape_str(trim($country_name)),
		   'state_name' => $this->db->escape_str(trim($state_name)),
		   'city_name' => $this->db->escape_str(trim($city_name)),
		   'admin_role_id' => $this->db->escape_str(trim($admin_role_id)),
		   'status' => $this->db->escape_str(trim($status)),
		   'password' => $this->db->escape_str(trim(md5($password))),
		   'created_by' => $this->db->escape_str(trim($created_by)),
		   'created_date' => $this->db->escape_str(trim($created_date)),
		   'created_by_ip' => $this->db->escape_str(trim($created_by_ip))
		);		

		//Inserting the record into the database.
		$this->db->dbprefix('admin');
		$ins_into_db = $this->db->insert('admin', $ins_data);
		
		//echo $this->db->last_query(); exit;
		
		if($ins_into_db){
			
			$new_admin_id = $this->db->insert_id();

			//Create User Directory if not exist
			$user_folder_path = './assets/user_files/'.$new_admin_id;
			
			if(!is_dir($user_folder_path))
				mkdir($user_folder_path);
				
			//Uploading profile Imaage
			if($_FILES['prof_image']['name'] != ''){
				
				$file_ext           = ltrim(strtolower(strrchr($_FILES['prof_image']['name'],'.')),'.'); 			
				$profile_file_name = 	'user_profile_'.$new_admin_id.'.jpg';
	
				$config['upload_path'] = $user_folder_path;
				$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
				$config['max_size']	= '1000';
				$config['overwrite'] = true;
				$config['file_name'] = $profile_file_name;
			
				$this->load->library('upload', $config);
				
				if(!$this->upload->do_upload('prof_image')){
					
					$error_file_arr = array('error' => $this->upload->display_errors());
					return $error_file_arr;
					
				}else{
					
					$data_image_upload = array('upload_image_data' => $this->upload->data());
					
					//Resize the Uploaded Image 180 * 180
					$config_profile['image_library'] = 'gd2';
					$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
					$config_profile['create_thumb'] = TRUE;
					$config_profile['thumb_marker'] = '';
					
					$config_profile['maintain_ratio'] = TRUE;
					$config_profile['width'] = 180;
					$config_profile['height'] = 180;
					
					$this->load->library('image_lib');
					$this->image_lib->initialize($config_profile);
					$this->image_lib->resize();
					$this->image_lib->clear();
					
					//Creating Thumbmail 28 * 28
					//Uploading is successful now resizing the uploaded image 
					$config_profile['image_library'] = 'gd2';
					$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
					$config_profile['new_image'] = $user_folder_path.'/t1-'.$profile_file_name;
					$config_profile['create_thumb'] = TRUE;
					$config_profile['thumb_marker'] = '';
					
					$config_profile['maintain_ratio'] = TRUE;
					$config_profile['width'] = 28;
					$config_profile['height'] = 28;
					
					$this->load->library('image_lib');
					$this->image_lib->initialize($config_profile);
					$this->image_lib->resize();
					$this->image_lib->clear();
		
				}//end if else if(!$this->upload->do_upload('upload_cv'))
				
				$upd_data['profile_image'] = $this->db->escape_str(trim($profile_file_name));
				
				//Updating the record into the database.
				$this->db->dbprefix('admin');
				$this->db->where('id',$new_admin_id);
				$upd_into_db = $this->db->update('admin', $upd_data);

			}//end if($_FILES['prof_image']['name'] != '')
			
			return true;
			
		}else
			return false;
		//end if($ins_into_db)
		
	}//end add_new_user

	//Edit Admin User Data
	public function edit_user($data){
		
		extract($data);
		
		$dob = date("Y-m-d", strtotime($dob));
		$join_date = date("Y-m-d", strtotime($join_date));
		$last_increament = date("Y-m-d", strtotime($last_increament));
		
		$last_modified_date = date('Y-m-d G:i:s');
		$last_modified_ip = $this->input->ip_address();
		$last_modified_by = $this->session->userdata('admin_id');
		
		$upd_data = array(
		   'first_name' => $this->db->escape_str(trim($first_name)),
		   'last_name' => $this->db->escape_str(trim($last_name)),
		   'display_name' => $this->db->escape_str(trim($display_name)),
		   'username' => $this->db->escape_str(trim($username)),
		   'email_address' => $this->db->escape_str(trim($email_address)),
		   'zip' => $this->db->escape_str(trim($zip)),
		   'phone' => $this->db->escape_str(trim($phone)),
		   'country_name' => $this->db->escape_str(trim($country_name)),
		   'state_name' => $this->db->escape_str(trim($state_name)),
		   'city_name' => $this->db->escape_str(trim($city_name)),
		   'admin_role_id' => $this->db->escape_str(trim($admin_role_id)),
		   'status' => $this->db->escape_str(trim($status)),
		   'last_modified_by' => $this->db->escape_str(trim($last_modified_by)),
		   'last_modified_date' => $this->db->escape_str(trim($last_modified_date)),
		   'last_modified_ip' => $this->db->escape_str(trim($last_modified_ip))
		);		

		if(trim($password) != ''){
			$upd_data['password'] =  $this->db->escape_str(trim(md5($password)));
		}

		//Create User Directory if not exist
		$user_folder_path = './assets/user_files/'.$admin_id;
		
		if(!is_dir($user_folder_path))
			mkdir($user_folder_path);
			
		//Uploading profile Imaage
		if($_FILES['prof_image']['name'] != ''){
			
			$file_ext           = ltrim(strtolower(strrchr($_FILES['prof_image']['name'],'.')),'.'); 			
			$profile_file_name = 	'user_profile_'.$admin_id.'.jpg';

			$config['upload_path'] = $user_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png';
			$config['max_size']	= '1000';
			$config['overwrite'] = true;
			$config['file_name'] = $profile_file_name;
		
			$this->load->library('upload', $config);
			
			if(!$this->upload->do_upload('prof_image')){
				
				$error_file_arr = array('error' => $this->upload->display_errors());
				return $error_file_arr;
				
			}else{
				
				$data_image_upload = array('upload_image_data' => $this->upload->data());
				
				//Resize the Uploaded Image 180 * 180
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 180;
				$config_profile['height'] = 180;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
				
				
				//Creating Thumbmail 28 * 28
				//Uploading is successful now resizing the uploaded image 
				$config_profile['image_library'] = 'gd2';
				$config_profile['source_image'] = $user_folder_path.'/'.$profile_file_name;
				$config_profile['new_image'] = $user_folder_path.'/t1-'.$profile_file_name;
				$config_profile['create_thumb'] = TRUE;
				$config_profile['thumb_marker'] = '';
				
				$config_profile['maintain_ratio'] = TRUE;
				$config_profile['width'] = 28;
				$config_profile['height'] = 28;
				
				$this->load->library('image_lib');
				$this->image_lib->initialize($config_profile);
				$this->image_lib->resize();
				$this->image_lib->clear();
	
			}//end if else if(!$this->upload->do_upload('upload_cv'))
			
			$upd_data['profile_image'] = $this->db->escape_str(trim($profile_file_name));
			
		}//end if($_FILES['prof_image']['name'] != '')

		//Updating the record into the database.
		$this->db->dbprefix('admin');
		$this->db->where('id',$admin_id);
		$upd_into_db = $this->db->update('admin', $upd_data);
		
		//echo $this->db->last_query(); exit;
		
		if($upd_into_db)
			return true;
		
	}//end edit_user
	
	//Delete Admin User
	public function delete_user($admin_id){
		
		if($admin_id != 1){
			
			//Deleting User folder
			if($admin_id!=''){
				$user_folder_path = './assets/user_files/'.$admin_id;
				$delete_user_folder = $this->mod_common->remove_directory($user_folder_path);
			}//end if($admin_id!='')
			
			//Delete the record from the database.
			$this->db->dbprefix('admin');
			$this->db->where('id',$admin_id);
			$del_into_db = $this->db->delete('admin');
			if($del_into_db) return true;
			//echo $this->db->last_query();

		}//end if($admin_id != 1)
		
	}//end delete_user
	
	
	public function add_site_preferences($data){
		
		extract($data);
		
		$ins_data = array(
		   'setting_name' => $this->db->escape_str(trim($name)),
		   'setting_value' => $this->db->escape_str(trim($value))
		);		

		//Inserting the record into the database.
		$this->db->dbprefix('site_preferences');
		$ins_into_db = $this->db->insert('site_preferences', $ins_data);
		
		return true;
		
	}//End Add site preferences
	
	
	public function get_site_preferences(){
		
		$this->db->dbprefix('site_preferences');
		
		$get_site_preferences= $this->db->get('site_preferences');

		//echo $this->db->last_query();exit;
		
		$get_site_preferences_arr['site_preferences_result'] = $get_site_preferences->result_array();
		$get_site_preferences_arr['site_preferences_count'] = $get_site_preferences->num_rows;
		
		
		
		return $get_site_preferences_arr;		
		
	}//end get_site_preferences
	
	
	public function edit_site_preferences($id){
		
		
		$this->db->dbprefix('site_preferences');
		$this->db->where('id',$id);
		$edit_preferences= $this->db->get('site_preferences');
		
		$edit_site_preferences_arr= $edit_preferences->row_array();
		
	    return $edit_site_preferences_arr;
		
		
	}//end update_Site Preferences
	
	
	public function update_site_preferences_process($data,$id){
		
		extract($data);
		
		$upd_data = array(
		   'setting_name' => $this->db->escape_str(trim($name)),
		   'setting_value' => $this->db->escape_str(trim($value))
		);		

		//Update the record into the database.
		$this->db->dbprefix('site_preferences');
		$this->db->where('id',$id);
		$upd_into_db = $this->db->update('site_preferences', $upd_data);
		
		//echo $this->db->last_query();
		
		if($upd_into_db)
			return true;
			
	}//end update_site_preferences process
	
	
	public function delete_site_preferences($id){
		
			//Delete the record from the database.
			$this->db->dbprefix('site_preferences');
			$this->db->where('id',$id);
			$del_into_db = $this->db->delete('site_preferences');
			
			if($del_into_db) return true;
			//echo $this->db->last_query();

		
	}//end delete_site_preferences
	
		
	//Get All Countries Name
	public function get_all_countries(){
		
		$this->db->dbprefix('countries');
		$this->db->select('id,country_name,iso')
		;$this->db->order_by('id DESC');
		$get_countries_list = $this->db->get('countries');
		//echo $this->db->last_query(); exit;
		
		
		$row_countries_list['countries_result'] = $get_countries_list->result_array();
		$row_countries_list['countries_count'] = $get_countries_list->num_rows;
		
		return $row_countries_list;		
		
	}//end get_all_countries
	
	
	
	
	public function get_states($county_name){
		
		$this->db->dbprefix('states');
		$this->db->select('id,state_name');
		$this->db->order_by('id DESC');
		$this->db->where('country',$county_name);
		$get_states_list = $this->db->get('states');
		//echo $this->db->last_query(); exit;
		$row_states_list['states_result'] = $get_states_list->result_array();
		$row_states_list['states_count'] = $get_states_list->num_rows;
		
		
		return $row_states_list;		
		
	}//end get_states
	
	
	
	public function get_cities($county_name){
		
		$this->db->dbprefix('cities');
		$this->db->select('name');
		$this->db->order_by('id DESC');
	 	$this->db->where('country_id',$county_name);
		$get_cities_list = $this->db->get('cities');
		//echo $this->db->last_query(); exit;
		
		$row_cities_list['cities_result'] = $get_cities_list->result_array();
		$row_cities_list['cities_count'] = $get_cities_list->num_rows;
		
		
		return $row_cities_list;		
		
	}//end get_cities
	
	
	//Get All State Name
	public function get_all_states($country_id){
		 
		$this->db->dbprefix('states');
		$this->db->where('country',$country_id);
		$this->db->order_by('id DESC');
		$get_states_list = $this->db->get('states');
		//echo $this->db->last_query(); exit;
		
		$row_states_list['states_result'] = $get_states_list->result_array();
		$row_states_list['states_count'] = $get_states_list->num_rows;
		
		
		$this->db->dbprefix('cities');
		$this->db->where('country_id',$country_id);
		$this->db->order_by('id DESC');
		$get_cities_list = $this->db->get('cities');
		//echo $this->db->last_query(); exit;
		
		$row_states_list['cities_result'] = $get_cities_list->result_array();
		$row_states_list['cities_count'] = $get_cities_list->num_rows;
		
		
		return $row_states_list;		
		
	}//end get_all_states
	
	
	
	//Edit User Data
	public function upload_docs($data){
		
	
		extract($data);
		
		$created_date = date('Y-m-d G:i:s');
		$created_by_ip = $this->input->ip_address();
		$created_by = $this->session->userdata('admin_id');
		
		for($i=0;$i<count($title);$i++){
					$ins_data = array(
					   'user_id' => $this->db->escape_str(trim($user_id)),
					   'title' => $this->db->escape_str(trim($title[$i])),
					   'description' => $this->db->escape_str(trim($short_desc[$i])),
					   'created_by' => $this->db->escape_str(trim($created_by)),
					   'created_date' => $this->db->escape_str(trim($created_date)),
					   'created_by_ip' => $this->db->escape_str(trim($created_by_ip))
					);		
					
					//Create User Directory if not exist
					$user_folder_path = './assets/user_files/'.$user_id;
					
					
					if(!is_dir($user_folder_path))
						mkdir($user_folder_path,0777);
					
		$name = $user_id.'_'.$_FILES['upload_doc']['name'][$i] ; 		
	 	$doc_file_name = 	'user_doc_'.$name;
		$ins_data['upload_doc'] = $this->db->escape_str(trim($doc_file_name));			
		
		//Inserting the record into the database.
		$this->db->dbprefix('user_docs');
		$ins_into_db = $this->db->insert('user_docs', $ins_data);
		}
			
			$this->load->helper(array('form', 'url'));
			$config['upload_path'] = $user_folder_path;
			$config['allowed_types'] = 'jpg|jpeg|gif|tiff|png|doc|docx|xls|xlsx|pdf';
			$config['max_size']	= '6000';
			$config['overwrite'] = true;
	
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->load->library('multipleupload',$config);

			$upload_epaper =  $this->multipleupload->do_multi_upload('upload_doc',TRUE,$user_id);
			
			
			return true;
		
	}//end Upload Docs
	
	
	
	//Get admin role name
	public function get_admin_role_name($role_id){
		
		global $chain_str;

		$this->db->dbprefix('admin_roles');
		$this->db->select('role_title');
		$this->db->where('id',$role_id);

		$get_admin_role_arr = $this->db->get('admin_roles');
		$row_admin_role_name = $get_admin_role_arr->row_array();
		
		
		$chain_str =  $row_admin_role_name['role_title'];
		
		return $chain_str;
		
	}//end admin_role_name
	
	
	
	
	//Filter Grid for Manage all admin users
	public function get_filter_admin_user_grid_data(){
		
		/* Array of database columns which should be read and sent back to DataTables. Use a space where
		* you want to insert a non-database field (for example a counter or static image)
		*/
        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        
        // DB table to use
        $sTable = 'admin';
		$this->db->order_by('id', DESC);
		
        //
    
        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);
    
        // Paging
        if(isset($iDisplayStart) && $iDisplayLength != '-1')
        {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }
        
        // Ordering
        if(isset($iSortCol_0))
        {
            for($i=0; $i<intval($iSortingCols); $i++)
            {
                $iSortCol = $this->input->get_post('iSortCol_'.$i, true);
                $bSortable = $this->input->get_post('bSortable_'.intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_'.$i, true);
    
                if($bSortable == 'true')
                {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }
        
				/*
		* Filtering
		* NOTE this does not match the built-in DataTables filtering which does it
		* word by word on any field. It's possible to do here, but concerned about efficiency
		* on very large tables, and MySQL's regex functionality is very limited
		*/
        if(isset($sSearch) && !empty($sSearch))
        {
            for($i=0; $i<count($aColumns); $i++)
            {
                $bSearchable = $this->input->get_post('bSearchable_'.$i, true);
                
                // Individual column filtering
                if(isset($bSearchable) && $bSearchable == 'true')
                {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS '.str_replace(' , ', ' ', implode(', ', $aColumns)), false);
		$this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);
        //echo $this->db->last_query(); exit;
        // Data set length after filtering
		$this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;
    
        // Total data set length
        $iTotal = $this->db->count_all($sTable);

    
        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
        foreach($rResult->result_array() as $aRow){
            $row = array();
            $option_html = '';
            foreach($aColumns as $col)
            {
				/*
				if($col == 'created_date'){
					 $row[] = date('d, M Y', strtotime($aRow[$col]));
				}
				*/
				
				if($col == '`display_name`'){
					 //$admin_name = stripslashes($this->mod_messages->get_admin_name($aRow['from']));
					 
					 $row[] = "<strong><a class='anchor_style' href=".SURL."admin/manage-user/user-detail/".$aRow['id']." title='Click to User Detail'>".$aRow['display_name']."</strong></a>";
					
					
				}
				elseif($col == 'admin_role_id'){
					
					 $admin_role_name = stripslashes($this->mod_admin->get_admin_role_name($aRow['admin_role_id']));
					 $row[] = $admin_role_name;
					
				}
				elseif($col == 'last_signin_date'){
					$row[] = date('d, M Y h:i:s a', strtotime(stripslashes($aRow['last_signin_date'])));
					
				}
				elseif($col == 'branch_id'){
					
					 $branch_name = stripslashes($this->mod_admin->get_admin_branch_name($aRow['branch_id']));
					 $row[] = $branch_name;
					
				}elseif($col == 'status'){
					
					$row[] = ($aRow[$col] == 1) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';

				}elseif($col == 'id'){
					$option_html .= '<div class="btn-group">';
					
					
					
					if(in_array(9,$this->session->userdata('permissions_arr'))){ 
						$option_html .= "<a href=".SURL."admin/manage-user/edit-user/".$aRow['id']." type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
					}//end if
					
					if(in_array(10,$this->session->userdata('permissions_arr'))){ 
						$option_html .= "<a href=".SURL."admin/manage-user/delete-user/".$aRow['id']." type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
					}//end if
					
				
					
					 $option_html .= '</div>';
					$row[] = $option_html;
					
					
				}
				else
				$row[] = $aRow[$col];
            }
    
            $output['aaData'][] = $row;
        }

		
        echo json_encode($output);
    }//end get_filter_inbox_read_grid_data
	
	
	

}
?>