<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_city extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('areas/mod_areas');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
	//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage City', base_url().'areas/manage-city');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_pages_add'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
         $get_city = $this->mod_areas->get_all_city();

		$data['city_arr'] = $get_city['get_city_arr'];
		$data['city_count'] = $get_city['city_row_count'];
		
		$this->load->view('areas/manage_city',$data);
		
	}
	       
	public function process_city_grid(){
            
		echo $this->mod_areas->get_filter_city_grid_data();
		
	}

	 
		public function add_city(){
      
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage City', base_url().'areas/manage-city/');
		$this->breadcrumbcomponent->add('Add New City', base_url().'areas/manage-city/add-city');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);

		//Fetching Table Listing
	   $get_countries = $this->mod_areas->get_all_countries();

		$data['countries_arr'] = $get_countries['countries_arr'];
		
		$this->load->view('areas/add_city',$data);
		
	}//add_state
	
	
	public function get_states_list(){
	 	 
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//State List List
		$get_all_states_list = $this->mod_areas->get_all_states($country_id);

		$data['states_result_arr'] = $get_all_states_list['states_result'];
		$data['states_result_count'] = $get_all_states_list['states_count'];
		
		$data['cities_result_arr'] = $get_all_states_list['cities_result'];
		$data['cities_result_count'] = $get_all_states_list['cities_count'];
		
		if($data['states_result_count'] >0){ // If State found in database .
		$response_select .= '<select  class="form-control"  id="state_name" name="state_name"  required><option value="0">Select State</option>' ;	
			
			for($p=0; $p < $data['states_result_count']; $p++){
				
				$response_select .= "<option value=".$data['states_result_arr'][$p]['id'].">".$data['states_result_arr'][$p]['state_name']."</option>" ;		
			}
		$response_select .= '</select>' ;		
		}else{
			
			$response_select .= ' <input id="state_name" name="state_name" type="text" class="form-control" placeholder="Enter State/Province Name "/>' ;	
			
			
		}
		
		
		echo $response_select ; 
		exit;
	}//get_states_list
        
	public function add_new_city_process(){
//            echo SURL."services/manage-services/add-new-service.'<br />'";
            
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_new_city_sbt')) 
		redirect(base_url().'areas/manage-city/add-city');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
            
	if(trim($this->input->post('country_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Country Name field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}elseif(trim($this->input->post('state_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- State Name field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}elseif(trim($this->input->post('city_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- City Name field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}
		elseif(trim($this->input->post('zip_code')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Zip Code Name field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- City Type field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}//end elseif(trim($this->input->post('status')) == '')

                else{
//                    echo 'else....'; exit();
			$add_new_state = $this->mod_areas->add_new_city($this->input->post());

			if($add_new_state){
				
				//Unset POST values from session
				
				
				$this->session->set_flashdata('ok_message', '- New City has been added successfully.');
				redirect(base_url().'areas/manage-city/add-city');
				
			}else{
				$this->session->set_flashdata('err_message', '- New City is not added. Something went wrong, please try again.');
				redirect(base_url().'areas/manage-city/add-city');
				
			}//end if($add_new_service)
			
		}//end 

	}//end add_new_state_process  
        

	    

	public function edit_city($city_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage city', base_url().'areas/manage-state');
		$this->breadcrumbcomponent->add('Edit city', base_url().'areas/manage-city/edit-city/'.$city_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		
		 $get_countries = $this->mod_areas->get_all_countries();

		$data['countries_arr'] = $get_countries['countries_arr'];
		
		//Fetching Table Listing
		       $get_state_data = $this->mod_areas->get_city_row($city_id);
                $data['state_row_arr'] = $get_state_data['state_row_arr'];
                $data['state_row_count'] = $get_state_data['state_row_count'];
                
//            exit($get_services_data['services_row_count']);
        if($get_state_data['state_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('areas/edit_city',$data);
		
	}


	public function edit_city_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('edit_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$cityid = $this->input->post('cityid');

		$err_msg = '';
		if(trim($this->input->post('country_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Country Name field is empty.');
			redirect(base_url().'areas/manage-city/edit-city/'.$cityid);
			
		}elseif(trim($this->input->post('state_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- State Name field is empty.');
			redirect(base_url().'areas/manage-city/edit-city/'.$cityid);
			
		}elseif(trim($this->input->post('city_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- City Name field is empty.');
			redirect(base_url().'areas/manage-city/edit-city/'.$cityid);
			
		}elseif(trim($this->input->post('zip_code')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Zip Code Name field is empty.');
			redirect(base_url().'areas/manage-city/add-city');
			
		}
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Status Type field is empty.');
			redirect(base_url().'areas/manage-city/edit-city/'.$cityid);
			
		}//end elseif(trim($this->input->post('status')) == '')
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'areas/manage-city/edit-city/'.$cityid);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_state = $this->mod_areas->edit_city($this->input->post());
		
                if($upd_state){

                        $this->session->set_flashdata('ok_message', '- City Record has been updated successfully.');
//                        redirect(base_url().'services/manage-services/edit-service/'.$service_id);
                        redirect(base_url().'areas/manage-city');

                }else{
                        $this->session->set_flashdata('err_message', '- City Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'areas/manage-city/edit-city/'.$cityid);

                }//end if($upd_service)

	}
        
        

	public function delete_city($city_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_city= $this->mod_areas->delete_city($city_id);
		
		if($del_city){
			
			$this->session->set_flashdata('ok_message', '- CITY deleted successfully.');
			redirect(base_url().'areas/manage-city');
			
		}else{
			$this->session->set_flashdata('err_message', '- CITY cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'areas/manage-city');
			
		}//end if

	}
}