<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_countries extends CI_Controller {
	
	public function __construct(){
		parent::__construct();

		$this->load->model('admin/mod_admin');
		$this->load->model('areas/mod_areas');
		$this->load->model('common/mod_common');
		
		$this->load->library('BreadcrumbComponent');
		
	}

	public function index(){
	
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if

		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 1;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 0;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 0;
		$data['PLUGIN_floatchart'] = 0;

		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;

		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;

		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Countries', base_url().'areas/manage-countries');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum',$data,true);
		 
		//Permissions
		$data['ALLOW_pages_add'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_edit'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
		$data['ALLOW_pages_delete'] =   (in_array(156,$this->session->userdata('permissions_arr'))) ? 1 : 0;
         $get_countries = $this->mod_areas->get_all_countries();

		$data['services_arr'] = $get_countries['countries_arr'];
		$data['countries_count'] = $get_countries['countries_row_count'];
		
		$this->load->view('areas/manage_country',$data);
		
	}
	       
	public function process_country_grid(){
            
		echo $this->mod_areas->get_filter_couties_grid_data();
		
	}

	public function add_country(){
      
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Areas', base_url().'areas/manage-countries/');
		$this->breadcrumbcomponent->add('Add New Country', base_url().'areas/manage-countries/add-country');
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);

		
		$this->load->view('areas/add_country',$data);
		
	}
        
	public function add_new_country_process(){
//            echo SURL."services/manage-services/add-new-service.'<br />'";
            
		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('add_new_country_sbt')) 
		redirect(base_url().'areas/manage-countries/add-country');
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
            
	

		if(trim($this->input->post('country_name')) == ''){
                    
			$this->session->set_flashdata('err_message', '- country Name field is empty.');
			redirect(base_url().'areas/manage-countries/add-country');
			
		}//end if(trim($this->input->post('service_name')) == '')
		elseif(trim($this->input->post('status')) == ''){
                    
			$this->session->set_flashdata('err_message', '- Country Type field is empty.');
			redirect(base_url().'areas/manage-countries/add-country');
			
		}//end elseif(trim($this->input->post('status')) == '')

                else{
//                    echo 'else....'; exit();
			$add_new_country = $this->mod_areas->add_new_country($this->input->post());

			if($add_new_country){
				
				//Unset POST values from session
				
				
				$this->session->set_flashdata('ok_message', '- New Country has been added successfully.');
				redirect(base_url().'areas/manage-countries/add-country');
				
			}else{
				$this->session->set_flashdata('err_message', '- New Country is not added. Something went wrong, please try again.');
				redirect(base_url().'areas/manage-countries/add-country');
				
			}//end if($add_new_service)
			
		}//end 

	}
        

	    

	public function edit_county($country_id){
		//Login Check
		$this->mod_admin->verify_is_admin_login();
		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		//Plugin Files Permission
		$data['PLUGIN_datagrid'] = 0;
		$data['PLUGIN_datepicker'] = 0;
		$data['PLUGIN_gcal'] = 0;
		$data['PLUGIN_form_validation'] = 1;
		$data['PLUGIN_gallery'] = 0;
		$data['PLUGIN_ckeditor'] = 1;
		$data['PLUGIN_floatchart'] = 0;
		
		//Common Includes
		$data['meta_title'] = DEFAULT_TITLE;
		$data['meta_keywords'] = DEFAULT_META_KEYWORDS;
		$data['meta_description'] = DEFAULT_META_DESCRIPTION;
		
		$fetch_nav_panel = $this->mod_common->fetch_admin_nav_panel();
		$data['nav_panel_arr'] = $fetch_nav_panel;
		
		//Bread crum
		$this->breadcrumbcomponent->add('Dashboard', base_url().'dashboard/dashboard');
		$this->breadcrumbcomponent->add('Manage Countries', base_url().'areas/manage-countries');
		$this->breadcrumbcomponent->add('Edit country', base_url().'areas/manage-countries/edit-county/'.$country_id);
		$data['breadcrum_data'] = $this->breadcrumbcomponent->output();
		
		$data['INC_header_script_top'] = $this->load->view('common/script_header',$data,true);
		$data['INC_header_script_footer'] = $this->load->view('common/script_footer',$data,true);
		$data['INC_top_header'] = $this->load->view('common/top_header','',true);
		$data['INC_left_nav_panel'] = $this->load->view('common/left_nav_panel',$data,true);
		$data['INC_footer'] = $this->load->view('common/footer','',true);
		$data['INC_breadcrum'] = $this->load->view('common/breadcrum','',true);
		
		//Fetching Table Listing
		       $get_country_data = $this->mod_areas->get_country_row($country_id);
                $data['country_row_arr'] = $get_country_data['country_row_arr'];
                $data['country_row_count'] = $get_country_data['country_row_count'];
                
//            exit($get_services_data['services_row_count']);
                if($get_country_data['country_row_count'] == 0 ) redirect (base_url() . 'errors/page-not-found-404');
                
		$this->load->view('areas/edit_country',$data);
		
	}


	public function edit_country_process(){

		//If Post is not SET
		if(!$this->input->post() && !$this->input->post('edit_country_sbt')) redirect(base_url());
		
		//Login Check
		$this->mod_admin->verify_is_admin_login();

		
		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$countryid = $this->input->post('countryid');

		$err_msg = '';
		if(trim($this->input->post('country_name')) == ''){
			
			$err_msg.= '- Country Name field cannot be empty.<br>';
			
		}//end if(trim($this->input->post('page_title')) == '')
		elseif(trim($this->input->post('status')) == ''){
			
			$err_msg.= '- Country Type field cannot be empty.<br>';
			
		}
		if($err_msg != ''){

			$this->session->set_flashdata('err_message', $err_msg);
			redirect(base_url().'areas/manage-countries/edit-county/'.$countryid);
			
		}//end if($err_msg !='')

		//Updating Table Data
		$upd_country = $this->mod_areas->edit_country($this->input->post());
		
                if($upd_country){

                        $this->session->set_flashdata('ok_message', '- Country Record has been updated successfully.');
//                        redirect(base_url().'services/manage-services/edit-service/'.$service_id);
                        redirect(base_url().'areas/manage-countries');

                }else{
                        $this->session->set_flashdata('err_message', '- Country Record has NOT been updated. Something went wrong, please try again.');
                        redirect(base_url().'areas/manage-countries/edit-county/'.$countryid);

                }//end if($upd_service)

	}
        
        

	public function delete_country($country_id){

		//Login Check
		$this->mod_admin->verify_is_admin_login();

		//Verify if Page is Accessable
		if(!in_array(156,$this->session->userdata('permissions_arr'))){
			redirect(base_url().'errors/page-not-found-404');
			exit;
		}//end if
		
		$del_country = $this->mod_areas->delete_country($country_id);
		
		if($del_country){
			
			$this->session->set_flashdata('ok_message', '- Country deleted successfully.');
			redirect(base_url().'areas/manage-countries');
			
		}else{
			$this->session->set_flashdata('err_message', '- Country cannot be deleted. Something went wrong, please try again.');
			redirect(base_url().'areas/manage-countries');
			
		}//end if

	}
}