<?php
class mod_areas extends CI_Model {
	
	function __construct(){
		
        parent::__construct();
    }
	//Get All Services.
	public function get_all_countries(){
		
		$this->db->dbprefix('countries');
		$this->db->order_by('id DESC');
		$get_countries = $this->db->get('countries');

		//echo $this->db->last_query();
		$row_countries['countries_arr'] = $get_countries->result_array();
	   $row_countries['countries_row_count'] = $get_countries->num_rows;

		return $row_countries;
		
	}//end get_all_services
	
	public function get_all_state(){
		
		$this->db->dbprefix('states');
		$this->db->order_by('id DESC');
		$get_state = $this->db->get('states');

		//echo $this->db->last_query();
		$row_state['state_arr'] = $get_state->result_array();
	   $row_state['state_row_count'] = $get_state->num_rows;

		return $row_state;
		
	}//end get_all_services

   public function get_all_city(){
		
		$this->db->dbprefix('cities');
		$this->db->order_by('id DESC');
		$get_city = $this->db->get('cities');

		//echo $this->db->last_query();
		$row_city['get_city_arr'] = $get_city->result_array();
	   $row_city['city_row_count'] = $get_city->num_rows;

		return $row_city;
		
	}//end get_all_services

    //Filter Grid for Manage Services
    public function get_filter_couties_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('country_name', 'status', 'id');

        // DB table to use
        $sTable = 'countries';
        $this->db->order_by('id DESC');


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
        foreach ($rResult->result_array() as $aRow) {
            $row = array();
            $option_html = '';
            foreach ($aColumns as $col) {

                if ($col == 'country_name') {
                    $row[] = "<strong>" . $aRow['country_name'] . "</strong>";
                }

                elseif ($col == 'status') {
                    $row[] = ($aRow[$col] == 0) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';
                } 
                elseif ($col == 'id') {
                    $option_html .= '<div class="btn-group">';

                    if (in_array(146, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-countries/edit-county/" . $aRow['id'] . " type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
                    }//end if

                    if (in_array(147, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-countries/delete-country/" . $aRow['id'] . " type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
                    }//end if


                    $option_html .= '</div>';
                    $row[] = $option_html;
                } else
                    $row[] = $aRow[$col];
            }

            $output['aaData'][] = $row;
        }


        echo json_encode($output);
    } //end get_filter_services_grid_data        

    
	   //Filter Grid for Manage Services
    public function get_filter_state_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('state_name','country', 'status', 'id');

        // DB table to use
        $sTable = 'states';
        $this->db->order_by('id DESC');


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
		$get_country = $this->db->query('SELECT bs.*, bc.country_name FROM bir_states bs, bir_countries bc WHERE bs.country=bc.id');
foreach($get_country->result() as $country) {
        foreach ($rResult->result_array() as $aRow) {
            $row = array();
            $option_html = '';
			
            foreach ($aColumns as $col) {

            
                    $row[] = "<strong>" . $country->state_name . "</strong>";
					$row[] = "<strong>" . $country->country_name . "</strong>";
						
              
                    $row[] = ($country->status == 0) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';
             
                    $option_html .= '<div class="btn-group">';

                    if (in_array(156, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-state/edit-state/" . $aRow['id'] . " type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
                    }//end if

                    if (in_array(156, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-state/delete-state/" . $aRow['id'] . " type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
                    }//end if


                    $option_html .= '</div>';
                    $row[] = $option_html;
                 
            }
}
            $output['aaData'][] = $row;
        }


        echo json_encode($output);
    } //end get_filter_services_grid_data  
    public function get_filter_city_grid_data() {

        /* Array of database columns which should be read and sent back to DataTables. Use a space where
         * you want to insert a non-database field (for example a counter or static image)
         */
//        $aColumns = array('`display_name`','username','admin_role_id','last_signin_date','status','id');
        $aColumns = array('name','state_id','country_id', 'status', 'id');

        // DB table to use
        $sTable = 'cities';
        $this->db->order_by('id DESC');


        $iDisplayStart = $this->input->get_post('iDisplayStart', true);
        $iDisplayLength = $this->input->get_post('iDisplayLength', true);
        $iSortCol_0 = $this->input->get_post('iSortCol_0', true);
        $iSortingCols = $this->input->get_post('iSortingCols', true);
        $sSearch = $this->input->get_post('sSearch', true);
        $sEcho = $this->input->get_post('sEcho', true);

        // Paging
        if (isset($iDisplayStart) && $iDisplayLength != '-1') {
            $this->db->limit($this->db->escape_str($iDisplayLength), $this->db->escape_str($iDisplayStart));
        }

        // Ordering
        if (isset($iSortCol_0)) {
            for ($i = 0; $i < intval($iSortingCols); $i++) {
                $iSortCol = $this->input->get_post('iSortCol_' . $i, true);
                $bSortable = $this->input->get_post('bSortable_' . intval($iSortCol), true);
                $sSortDir = $this->input->get_post('sSortDir_' . $i, true);

                if ($bSortable == 'true') {
                    $this->db->order_by($aColumns[intval($this->db->escape_str($iSortCol))], $this->db->escape_str($sSortDir));
                }
            }
        }

        /*
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        if (isset($sSearch) && !empty($sSearch)) {
            for ($i = 0; $i < count($aColumns); $i++) {
                $bSearchable = $this->input->get_post('bSearchable_' . $i, true);

                // Individual column filtering
                if (isset($bSearchable) && $bSearchable == 'true') {
                    $this->db->or_like($aColumns[$i], $sSearch);
                }
            }
        }


        // Select Data
        $this->db->select('SQL_CALC_FOUND_ROWS ' . str_replace(' , ', ' ', implode(', ', $aColumns)), false);
        $this->db->dbprefix($sTable);
        $rResult = $this->db->get($sTable);

        // Data set length after filtering
        $this->db->dbprefix($sTable);
        $this->db->select('FOUND_ROWS() AS found_rows');
        $iFilteredTotal = $this->db->get()->row()->found_rows;

        // Total data set length
        $iTotal = $this->db->count_all($sTable);


        // Output
        $output = array(
            'sEcho' => intval($sEcho),
            'iTotalRecords' => $iTotal,
            'iTotalDisplayRecords' => $iFilteredTotal,
            'aaData' => array()
        );
		$get_country = $this->db->query('SELECT bs.*, bc.country_name, bd.state_name FROM bir_cities bs, bir_countries bc,bir_states bd WHERE bs.country_id=bc.Id AND bs.state_id=bd.id ');
		
foreach($get_country->result() as $country) {
        foreach ($rResult->result_array() as $aRow) {
            $row = array();
            $option_html = '';
			
            foreach ($aColumns as $col) {

            
                    $row[] = "<strong>" . $country->name . "</strong>";
				    $row[] = "<strong>" . $country->state_name . "</strong>";
					$row[] = "<strong>" . $country->country_name . "</strong>";
						
              
                    $row[] = ($country->status == 0) ? '<span class="label btn-success">Active</span>' : '<span class="label btn-danger">InActive</span>';
             
                    $option_html .= '<div class="btn-group">';

                    if (in_array(156, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-city/edit-city/" . $aRow['id'] . " type='button' class='btn btn-info btn-gradient'> <span class='glyphicons glyphicons-edit'></span> </a>";
                    }//end if

                    if (in_array(156, $this->session->userdata('permissions_arr'))) {
                        $option_html .= "<a href=" . SURL . "areas/manage-city/delete-city/" . $aRow['id'] . " type='button' class='btn btn-danger btn-gradient' onClick=\"return confirm('Are you sure you want to delete?')\"> <span class='glyphicons glyphicons-remove'></span> </a>";
                    }//end if


                    $option_html .= '</div>';
                    $row[] = $option_html;
                 
            }
}
            $output['aaData'][] = $row;
        }


        echo json_encode($output);
    } //end get_filter_services_grid_data  
	
	
	
	
	
	
	
	
    //Add New areas
    public function add_new_country($data) {
        extract($data);

//        $table_seats = $this->input->post('table_seats');
       
        $ins_data = array(
            'country_name' => $this->db->escape_str(trim($country_name)),
            'status' => $this->db->escape_str(trim($status)),
           
//		   'table_discription' =>     $this->db->escape_str(trim(nl2br($table_discription))),
        );

        //Insert the record into the database.
        $this->db->dbprefix('countries');
        $ins_into_db = $this->db->insert('countries', $ins_data);

        if ($ins_into_db)
            return true;
    } 
    public function add_new_state($data) {
        extract($data);


       
        $ins_data = array(
            'country' => $this->db->escape_str(trim($country)),
			'state_name' => $this->db->escape_str(trim($state_name)),
            'status' => $this->db->escape_str(trim($status)),
            );

        //Insert the record into the database.
        $this->db->dbprefix('states');
        $ins_into_db = $this->db->insert('states', $ins_data);

        if ($ins_into_db)
            return true;
    } //end add_new_service()
	public function add_new_city($data) {
        extract($data);


       
        $ins_data = array(
            'name' => $this->db->escape_str(trim($city_name)),
			'zipcode' => $this->db->escape_str(trim($zip_code)),
			'state_id' => $this->db->escape_str(trim($state_name)),
			'country_id' => $this->db->escape_str(trim($country_name)),
            'status' => $this->db->escape_str(trim($status)),
            );

        //Insert the record into the database.
        $this->db->dbprefix('cities');
        $ins_into_db = $this->db->insert('cities', $ins_data);

        if ($ins_into_db)
            return true;
    } //end add_new_service()
	
	
	

   public function get_all_states($country_id){
		
		$this->db->dbprefix('states');
		$this->db->where('country',$country_id);
		$this->db->order_by('id DESC');
		$get_states_list = $this->db->get('states');
		//echo $this->db->last_query(); exit;
		
		$row_states_list['states_result'] = $get_states_list->result_array();
		$row_states_list['states_count'] = $get_states_list->num_rows;

		
		
		return $row_states_list;		
		
	}//end get_all_states

	
	
	
    //Delete Services Record
    public function delete_country($country_id) {

        //Delete the record from the database.
        $this->db->dbprefix('countries');
        $this->db->where('Id', $country_id);
        $del_into_db = $this->db->delete('countries');
	   if ($del_into_db)
            return true;
        //	echo $this->db->last_query();
    }  
    public function delete_state($state_id) {

        //Delete the record from the database.
        $this->db->dbprefix('states');
        $this->db->where('id', $state_id);
        $del_into_db = $this->db->delete('states');
	   if ($del_into_db)
            return true;
        //	echo $this->db->last_query();
    }  
    

  public function delete_city($city_id) {

        //Delete the record from the database.
        $this->db->dbprefix('cities');
        $this->db->where('id', $city_id);
        $del_into_db = $this->db->delete('cities');

	   if ($del_into_db)
            return true;
        //	echo $this->db->last_query();
    }  
    
    
    // get specific record    
    function get_country_row($country_id) {

        $this->db->dbprefix('countries');
        $this->db->where('Id', $country_id);
        $get_countries_row = $this->db->get('countries');
        //        echo $this->db->last_query();

        $countries_row['country_row_arr'] = $get_countries_row->row_array();
        $countries_row['country_row_count'] = $get_countries_row->num_rows;

        return $countries_row;
    }
    function get_state_row($state_id) {

        $this->db->dbprefix('states');
        $this->db->where('id', $state_id);
        $get_state_row = $this->db->get('states');
        //        echo $this->db->last_query();

        $state_row['state_row_arr'] = $get_state_row->row_array();
        $state_row['state_row_count'] = $get_state_row->num_rows;

        return $state_row;
    }
	
	function get_city_row($city_id) {

        $this->db->dbprefix('cities');
        $this->db->where('id', $city_id);
        $get_state_row = $this->db->get('cities');
        //        echo $this->db->last_query();

        $state_row['state_row_arr'] = $get_state_row->row_array();
        $state_row['state_row_count'] = $get_state_row->num_rows;

        return $state_row;
    }
	
	

    //Edit Service Data
    public function edit_country($data) {
    
        extract($data);
        $upd_data = array(
            'country_name' => $this->db->escape_str(trim($country_name)),
            'status' => $this->db->escape_str(trim($status))
        );


        //Updating the record into the database.
        $this->db->dbprefix('countries');
        $this->db->where('Id', $countryid);
        $upd_into_db = $this->db->update('countries', $upd_data);
        //echo $this->db->last_query(); exit;

        if ($upd_into_db)
            return true;
    }
	
	  public function edit_state($data) {

        extract($data);
        $upd_data = array(
		   'state_name' => $this->db->escape_str(trim($state_name)),
            'country' => $this->db->escape_str(trim($country)),
            'status' => $this->db->escape_str(trim($status))
        );


        //Updating the record into the database.
        $this->db->dbprefix('states');
        $this->db->where('id', $stateid);
        $upd_into_db = $this->db->update('states', $upd_data);
        //echo $this->db->last_query(); exit;

        if ($upd_into_db)
            return true;
    }
	
   public function edit_city($data) {

        extract($data);
        $upd_data = array(
		    'name' => $this->db->escape_str(trim($city_name)),
			'zipcode' => $this->db->escape_str(trim($zip_code)),
			'state_id' => $this->db->escape_str(trim($state_name)),
			'country_id' => $this->db->escape_str(trim($country_name)),
            'status' => $this->db->escape_str(trim($status)),
        );


        //Updating the record into the database.
        $this->db->dbprefix('cities');
        $this->db->where('id', $cityid);
        $upd_into_db = $this->db->update('cities', $upd_data);
        //echo $this->db->last_query(); exit;

        if ($upd_into_db)
            return true;
    }
//end edit_table
}
